# -*- coding: utf-8 -*-

import socket

import redis


__all__ = [
    'APIS_REGISTRY',
    'HOSTNAME',
    'LDAP_API'
    ]

# récupération du nom de la machine sur laquelle blueflask ext exécuté
HOSTNAME = socket.gethostname()

# par défaut, l'API ldap utilisée est celle en dev
LDAP_API = 'https://bldv040v.blueline.mg/ldap-services/api/v2'

# par défaut, le répertoire d'API est stocké localement dans une base redis
# à l'index 15; ce répertoire contient toutes les informations sur les
# APIs qui sont déclarées en marche, leurs identifiants, etc.
APIS_REGISTRY = redis.Redis(db=15)

if HOSTNAME.startswith('blpr'):  # si blueflask est sur un serveur de prod
    LDAP_API = 'https://blpr044v.blueline.mg/ldap-services/api/v2'
    APIS_REGISTRY = redis.Redis(host='api-gateway.malagasy.com', db=15)
elif HOSTNAME.startswith('blst'):  # si blueflask est sur un serveur staging
    LDAP_API = 'https://blst040v.blueline.mg/ldap-services/api/v2'

# EOF
