#!/usr/bin/env python
# encoding: utf-8


from setuptools import setup, find_packages

setup(
    name="dvbbox",
    version='1.9.4',
    packages=find_packages(),
    author="Blueline Madagascar",
    author_email="dev@si.blueline.mg",
    license="MIT",
    install_requires=[
        'click==6.7',
        'pika==0.11.2',
        'pyyaml==3.12',
        'records==0.5.2',
        'redis==2.10.6',
        'requests==2.19.1',
        'systemd-python==234',
        'xmltodict==0.11.0',
        'blueflask==1.1',
        'to-log==0.2'
        ],
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'dvbbox=dvbbox.api.cli:cmd',
            ],
        }
    )

# EOF
