# dvbbox

dvbbox est un media manager & player, en ligne de commande, permettant de diffuser des listes de lecture ("playlists")
sur un réseau de diffusion de télévision numérique (DVB-T/DVB-T2)

dvbbox permet de:

  - gérer les différents fichiers TS ("transport stream") présents sur le disque
  
  - organiser les fichiers TS en listes de lectures à diffuser un jour donné (programmation)
  
  - modifier les listes de lecture
  
  - diffuser les listes de lecture

La particularité de cet outil, est d'utiliser l'utilitaire [DtPlay](https://www.dektec.com/products/applications/DtPlay/downloads/DtPlay.zip)
de [DekTec](https://www.dektec.com) pour effectuer la diffusion via une carte [DekTec DTA-2162](https://www.dektec.com/products/PCIe/DTA-2162/).

Il peut aussi utiliser [VLC](https://www.videolan.org/vlc/index.html).

## Pré-requis

### Paquets Système

  - python3.x
  
  - python3-dev
  
  - redis-server
  
  - libav-tools
  
  - ffmpeg
  
  - DtPlay
  
  - VLC (optionnel)

### Paquets Python

  - click
  
  - redis
  
## Installation

Il est recommandé d'installer l'application dans un environnement virtuel.

### Par défaut

```shell
$ python3 -m venv .env
$ .env/bin/pip install --index http://miroir.blueline.mg/pypi dvbbox
```

L'interface en ligne de commande est accessible via `.env/bin/dvbbox`

### Installation chez Blueline


```shell
$ sudo mkdir /etc/dvbbox
$ sudo chown -R dvb.dvb /etc/dvbbox
$ sudo -u dvb python3 -m venv /etc/dvbbox/.env
$ sudo -u dvb /etc/dvbbox/.env/bin/pip install --index http://miroir.blueline.mg/pypi --trusted-host miroir.blueline.mg dvbbox
$ sudo touch /etc/dvbbox/dvbbox.conf
$ sudo ln -s /etc/dvbbox/.env/bin/dvbbox /usr/local/bin/dvbbox
$ sudo mkdir -p /opt/dvbbox/tsfiles
$ sudo mkdir /opt/dvbbox/images
$ sudo mkdir /opt/dvbbox/audios
$ sudo mkdir /opt/dvbbox/playlists
$ sudo mkdir /opt/dvbbox/uploads
$ sudo mkdir /opt/dvbbox/mods
```

## Liste des commandes disponibles


### recherche du master dans le cluster

```shell
$ dvbbox ping
```

### activation d'un serveur en mode master

```shell
$ dvbbox enable [--hostname]
```

### incrustation de panneau (individuel)

```shell
$ dvbbox merge FILENAME [--image] [--service-id]
```

### incrustation de panneaux

```shell
$ dvbbox embed_images DATE SERVICE_ID
```

### diffusion d'un fichier

```shell
$ dvbbox play media FILENAME [--service-id] [--output]
```

### diffusion d'un programme

```shell
$ dvbbox play program DDMMYYYY --service-id X [--output]
```

### synchronisation des fichiers manquants

```shell
$ dvbbox sync media
```

### synchronisation des programmes avec le master

```shell
$ dvbbox sync program --date DDMMYYYY --service-id X
```

### récupération d'un fichier

```shell
$ dvbbox fetch media FILENAME [--hostname]
```

### vérification d'un fichier

```shell
$ dvbbox check media FILENAME
```

### vérification d'un programme

```shell
$ dvbbox check program DDMMYYYY [--service-id X] [--coherence] [--send Y]
```
