#!/usr/bin/env python
# encoding: utf-8


"""
Command Line Interface
"""

from blueflask.lib.amqp_worker import worker, Worker

from . import app

import click


@click.group()
def cmd():
    pass


@cmd.command()
@click.argument('queue')
@click.option('--workers', type=int, default=1)
def async_daemon(queue, workers):
    """Lance un ou plusieurs workers pour une file d'attente"""

    if not workers:
        click.echo("Il me faut au moins un worker")
    elif workers == 1:
        worker(queue, 'hlr')
    else:
        threads = [
            Worker('worker-{}'.format(i), queue, 'hlr')
            for i in range(workers)
            ]
        for thread in threads:
            thread.start()


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(host=host, port=port, debug=True)
