# -*- coding: utf-8 -*-

from flask import Blueprint, request

from blueflask.lib.errors import not_allowed, not_found
from blueflask.lib.errors import internal_error, unauthorized

from ...consts import SERVICE_CODE

import traceback


__version__ = "1.0"

api = Blueprint("api", __name__, url_prefix="/api/v1")


@api.errorhandler(401)
def unauthorized_error(e):
    return unauthorized(
        request_id=request.headers.get("X-Request-Id"), service_code=SERVICE_CODE
    )


@api.errorhandler(404)
def not_found_error(e):
    return not_found(
        request_id=request.headers.get("X-Request-Id"), service_code=SERVICE_CODE
    )


@api.errorhandler(405)
def method_not_allowed_error(e):
    return not_allowed(
        request_id=request.headers.get("X-Request-Id"), service_code=SERVICE_CODE
    )


@api.errorhandler(500)
def internal_server_error(e):
    message = {
        "error": str(e),
        "traceback": "".join(traceback.format_tb(e.__traceback__)),
    }
    return internal_error(
        message,
        request_id=request.headers.get("X-Request-Id"),
        service_code=SERVICE_CODE,
    )


from . import auth  # NOQA
from . import subscribers  # NOQA
from . import services  # NOQA

# EOF
