# -*- coding: utf-8 -*-

from rest_client import RestClient
from to_log import Logger
import glob
import configparser
import socket
import requests
import datetime


__all__ = [
    'ADDRESS',
    'APIGW',
    'API_LOGS',
    'BLUEFLASK_LOGS',
    'CONFIG',
    'HOSTNAME',
    'LOGS',
    'ODOO_CLIENT',
    'REST_CLIENT_LOGS'
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/odoo-services/odoo-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
if HOSTNAME.startswith('bldv'):
    APIGW = 'bldv040v.blueline.mg'
elif HOSTNAME.startswith('blst'):
    APIGW = 'blst040v.blueline.mg'
else:
    APIGW = 'api.blueline.mg'

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('odoo-services', level=LOG_LEVEL)
LOGS.set_file_handler(LOG_FILE)

API_LOGS = Logger('odoo-services-api', level=LOG_LEVEL)
API_LOGS.set_file_handler(LOG_FILE)

REST_CLIENT_LOGS = Logger(
    'rest_client',
    level=LOG_LEVEL
    )
REST_CLIENT_LOGS.set_file_handler(LOG_FILE)

BLUEFLASK_LOGS = Logger(
    'blueflask',
    level=LOG_LEVEL
    )
BLUEFLASK_LOGS.set_file_handler(LOG_FILE)
SESSION = requests.Session()

SESSION.get(
    CONFIG['ODOO_API']['auth'],
    json={
        'jsonrpc': '2.0',
        'params': {
            'db': CONFIG['ODOO_API']['db'],
            'login': CONFIG['ODOO_API']['username'],
            'password': CONFIG['ODOO_API']['password']
            }
        }
    )

ODOO_CLIENT = RestClient(CONFIG['ODOO_API']['root'], interface=SESSION)

ODOO_URI = CONFIG['ODOO_API']['url']
LOGIN_ODOO = {
        'jsonrpc': '2.0',
        'params': {
            'db': CONFIG['ODOO_API']['db'],
            'login': CONFIG['ODOO_API']['username'],
            'password': CONFIG['ODOO_API']['password']
            }
        }

FILES = sorted(
    glob.glob(
        '{path}/*{date}.txt'.format(
            path=CONFIG['BIOSERVER']['path'],
            date=(
                datetime.date.today()-datetime.timedelta(1)).strftime(
                "%Y%m%d"
                )
            )
        )
    )

db = CONFIG['ODOO_API']['db']
username = CONFIG['ODOO_API']['username']
password = CONFIG['ODOO_API']['password']

ussd_partner = CONFIG['USSD_PARTNER']

# EOF
