# -*- coding: utf-8 -*-

from .consts import ODOO_CLIENT


class VacationRequest(object):

    def __init__(self, request_id):
        self.request_id = request_id
        self.data = {
            "jsonrpc": "2.0",
            "params": {}
            }

    def status(self):
        response = ODOO_CLIENT.get(
            '/vacations/requests/{}'.format(self.request_id)
            )
        return response

    def update(self, **kwargs):
        self.data['params']['vals'] = kwargs
        response = ODOO_CLIENT.put(
            '/vacations/requests/{}'.format(self.request_id),
            json=self.data
            )
        return response

    def delete(self):
        self.data['params'] = {}
        response = ODOO_CLIENT.delete(
            '/vacations/requests/{}'.format(self.request_id),
            json=self.data
            )
        return response

    @staticmethod
    def create(date_from, date_to, employee_id, name=None, note=None):
        data = {
            'jsonrpc': '2.0',
            'params': {
                'vals': {
                    'date_from': date_from,
                    'date_to': date_to,
                    'employee_id': employee_id,
                    'name': name or 'Demande de congés'
                    }
                }
            }
        response = ODOO_CLIENT.post('/vacations/requests', json=data)
        if response.status_code == 200:
            response = response.json()
            if 'request_id' in response['content']:  # ça a marché
                response = {
                    "status": response.status_code,
                    "message": response['content']['request_id']
                    }
            else:
                response = {"status": response.status_code, "message": "error"}
        else:
            response = {"status": response.status_code, "message": "error"}

    @staticmethod
    def get_balance(employee_id):
        response = ODOO_CLIENT.get(
            '/vacations/{}'.format(employee_id)
            )
        if response.status_code == 200:
            response = response.json()
        else:
            response = {"status": response.status_code, "message": "error"}
        return response

    @staticmethod
    def balance_by_matricule(matricule):
        response = ODOO_CLIENT.get(
            '/vacations/{}?search_by=matricule'.format(matricule)
            )
        if response.status_code == 200:
            status = response.status_code
            response = response.json()
            if response.get("error"):
                response = {
                    "status": response["code"],
                    "message": response["error"]
                    }
            else:
                response = {
                    "status": status,
                    "message": response["vacations"]
                    }
        else:
            response = {
                "status": response.status_code,
                "message": "error"
                }
        return response

    @staticmethod
    def team_balance(employee_id):
        response = ODOO_CLIENT.get(
            '/vacations/employees/{}'.format(employee_id)
            )
        if response.status_code == 200:
            response = response.json()
        else:
            response = {"status": response.status_code, "message": "error"}
        return response

# EOF
