# -*- coding: utf-8 -*-

from xmlrpc import client
import configparser

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/odoo-services/odoo-services.conf')
url = CONFIG['ODOO_XMLRPC']['root']
db = CONFIG['ODOO_XMLRPC']['db']
username = CONFIG['ODOO_XMLRPC']['username']
password = CONFIG['ODOO_XMLRPC']['password']
fields = [
    'name',
    'id_dest',
    'id_init',
    'transaction_date',
    'source_platform',
    'id_transaction_source',
    'users',
    'amount',
    'channel',
    'transaction_type',
    'product_type',
    'description',
    'ref_unique',
    'product_name',
    'recharge_name'
]
common = client.ServerProxy(
    '{}/xmlrpc/2/common'.format(url)
    )
uid = common.authenticate(db, username, password, {})
models = client.ServerProxy('{}/xmlrpc/2/object'.format(url))


class AccountPrepaid(object):

    def __init__(self, refnum_unique):
        self.refnum_unique = refnum_unique

    def transaction_info(self):
        record = models.execute_kw(
            db,
            uid,
            password,
            'blueline.account.prepaid.move',
            'search_read',
            [
                [
                    ['refnum_unique', '=', self.refnum_unique]
                ]
            ],
            {'fields': fields}
        )
        return record

    @staticmethod
    def get_id(refnum_unique):
        id = models.execute_kw(
            db,
            uid,
            password,
            'blueline.account.prepaid.move',
            'search',
            [
                [
                    ['refnum_unique', '=', refnum_unique]
                ]
            ]
        )
        return id

    @staticmethod
    def create(params):
        id = models.execute_kw(
            db,
            uid,
            password,
            'bueline.account.prepaid.move',
            'create',
            [
                {key: value for key, value in params.items() if key in fields}
            ]
        )
        return id

    @staticmethod
    def update(refnum_unique, params):
        # get id
        id = AccountPrepaid.get_id(refnum_unique)
        # update record
        models.execute_kw(
            db,
            uid,
            password,
            'blueline.account.prepaid.move',
            'write',
            [
                [id],
                {key: value for key, value in params.items() if key in fields}
            ]
        )
        record = models.execute_kw(
            db,
            uid,
            password,
            'blueline.account.prepaid.move',
            'name_get', [
                [id]
            ]
        )
        return record

    @staticmethod
    def delete(refnum_unique):
        id = AccountPrepaid.get_id(refnum_unique)
        models.execute_kw(
            db,
            uid,
            password,
            'res.partner',
            'unlink',
            [
                [id]
            ]
        )
        record = models.execute_kw(
            db,
            uid,
            password,
            'res.partner',
            'search',
            [
                [
                    ['id', '=', id]
                ]
            ]
        )
        if record == []:
            return 'Succes'
# EOF
