#!/usr/bin/env pythony
# encoding: utf-8

from blueflask.lib.errors import bad_request
from flask import request
from ...accountprepaid import AccountPrepaid
from ...consts import SERVICE_CODE
from . import api


@api.route('/accountprepaid/requests', methods=['POST'])
def accountprepaid_request():
    data = request.get_json()
    id = AccountPrepaid.create(data)
    if not id:
        return bad_request(
            'Provide a valid JSON document',
            service_code=SERVICE_CODE
            )
    else:
        return id


@api.route('/accountprepaid/update/<string:refnum_unique>', methods=['PUT'])
def accountprepaid_update(refnum_unique):
    data = request.get_json()
    record = AccountPrepaid.update(refnum_unique, data)
    if not record:
        return bad_request(
            'Provide a vaid JSON document',
            service_code=SERVICE_CODE
            )
    return record


@api.route('/accountprepaid/delete/<string:refnum_unique>', methods=['DALETE'])
def accountprepaid_delete(refnum_unique):
    record = AccountPrepaid.delete(refnum_unique)
    if record == 'Succes':
        return record
    else:
        return 'Faild'


@api.route('/accountprepaid/info/<string:refnum_unique>', methods=['GET'])
def accountprepaid_info(refnum_unique):
    accountprepaid = AccountPrepaid(refnum_unique)
    record = accountprepaid.transaction_info()
    if record:
        return record
    else:
        message = 'Ce {} n\'existe pas!'.format(refnum_unique)
        return message

# EOF
