#!/usr/bin/env python
# encoding: utf-8

from ..izytv import IzyTV
from . import app
import click


@click.group()
def cmd():
    pass


@cmd.command()
def active_bouquet():
    izytv = IzyTV()
    izytv.activate_bouquet()


@cmd.command()
def writeToDB():
    izytv = IzyTV()
    izytv.writeToDB()


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(
        host=host,
        port=port,
        debug=True
    )

# EOF
