from flask import jsonify, request
from ...orangemoney import OrangeMoney
from ...consts import LOGS
from . import api
import requests
import json


@api.route('/orangemoney/paymentRequest', methods=['POST'])
def orangePaymentRequest():
    data = request.get_json()
    LOGS.logger.info(data)
    orangemoney = OrangeMoney()
    response = orangemoney.paymentRequest(data)
    return jsonify(response)


@api.route('/orangemoney/checkTransactionStatus', methods=['POST'])
def orangeCheckTransactionStatus():
    data = request.get_json()
    LOGS.logger.info(data)
    orangemoney = OrangeMoney()
    response = orangemoney.checkTransactionStatus(data)
    return jsonify(response)


@api.route("/orangemoney/checkRedis", methods=["GET"])
def OrangecheckRedis():
    """
    Pour Checker le status de la transaction
    """
    data = request.get_json()
    LOGS.logger.info("\n\nCheck ORANGEMONEY transaction status\n\n")
    orangemoney = OrangeMoney()
    response = orangemoney.checkTransactionStatusRedis(data["operation_id"])
    return jsonify(response)
# EOF
