#!/usr/bin/env python
# encoding: utf-8

from .consts import LOGS, REDIS_DB
from .mvola import Mvola
from .orangemoney import OrangeMoney
from .airtelmoney import AirtelMoney
from .bluebase import izytv_buy_recharge
from .core import write_transaction_to_db
import records
import json
import datetime

trans_timeout = 15


def decode(val):
    data = {key.decode('utf-8'): value.decode('utf-8') for (key, value) in val.items()}
    return data


class IzyTV(object):

    def __init__(self):
        self.all_transaction = REDIS_DB.keys()

    def activate_bouquet(self):
        for i in self.all_transaction:
            transId = i.decode('utf-8')
            val = REDIS_DB.hgetall(i)
            data = decode(val)
            if (data["status"] == "Transaction en cours") or (data["status"] == "En attente de paiement") or (data["info"] == "Activation en attente"):
                if data["operator"] == "telma-izytv":
                    mvola = Mvola()
                    response = mvola.checkTransactionStatus(data["partner_ref"])
                    if response["status"] != 404:
                        if response["status"] == 200:
                            data["status"] = "Transaction validée"
                            params = {
                                'session': '',
                                "operator": data["operator"],
                                "caller_num": data["caller_num"],
                                "service_type": data["service_type"],
                                "client_refnum": data["client_refnum"],
                                "device_id": data["device_id"],
                                "solde": data["amount"],
                                "offre_refnum": data["offre_refnum"],
                                "partner_ref": response["response"]["MvolaTransactionID"]
                            }
                            LOGS.logger.info("data: " + json.dumps(params))
                            result = izytv_buy_recharge(params)
                            if result["status"] == 200:
                                LOGS.logger.info(result)
                                data["info"] = "Activation reussie"
                                data["partner_ref"] = response["response"]["MvolaTransactionID"]
                                record = REDIS_DB.hmset(transId, data)
                                while not record:
                                    record = REDIS_DB.hmset(transId, data)
                                # Mettre à jour la base postgres
                            else:
                                LOGS.logger.info(result)
                                # On réactivate plus tard
                        elif response["status"] == 2:  # Processus en cours
                            data["status"] = "En attente de paiement"
                            record = REDIS_DB.hmset(transId, data)
                            while not record:
                                record = REDIS_DB.hmset(transId, data)
                        elif response["status"] == 3:  # Transaction annulée coté telma
                            data["status"] = "Transaction annulée"
                            data["info"] = "Activation annulée"
                            record = REDIS_DB.hmset(transId, data)
                            while not record:
                                record = REDIS_DB.hmset(transId, data)
                        elif response["status"] == 1:  # en attente
                            date = datetime.datetime.strptime(
                                data["TransactionDate"],
                                "%Y-%m-%d %H:%M:%S"
                            )
                            now = datetime.datetime.now()
                            if ((now - date).total_seconds() / 60.0) >= trans_timeout:
                                data["status"] = "Transaction annulée"
                                data["info"] = "Activation annulée"
                                record = REDIS_DB.hmset(transId, data)
                                while not record:
                                    record = REDIS_DB.hmset(transId, data)
                    else:
                        LOGS.logger.info(response)
                elif data["operator"] == "orange-izytv":
                    trans_info = {
                        'amount': data['amount'],
                        'order_id': data['order_id'],
                        'pay_token': data['partner_ref'],
                    }
                    response = OrangeMoney().checkTransactionStatus(trans_info)
                    LOGS.logger.info(response)
                    STATUS = {
                        4: "Transaction validée",
                        1: "En attente de paiement",
                        2: "En attente de paiement",
                        3: "Transaction annulée",
                    }
                    rstatus = response['status']
                    data['status'] = STATUS[rstatus]
                    data['info'] = STATUS[rstatus]

                    if rstatus == 4:  # Succeeded
                        params = {
                            'session': '',
                            "operator": data["operator"],
                            "caller_num": data["caller_num"],
                            "service_type": data["service_type"],
                            "client_refnum": data["client_refnum"],
                            "device_id": data["device_id"],
                            "solde": data["amount"],
                            "offre_refnum": data["offre_refnum"],
                            "partner_ref": data["partner_ref"]
                        }
                        LOGS.logger.info("data: " + json.dumps(params))
                        result = izytv_buy_recharge(params)
                        if result["status"] == 200:
                            LOGS.logger.info(result)
                            data["info"] = "Activation reussie"
                    elif rstatus == 1 or rstatus == 2:  # Pending
                        date = datetime.datetime.strptime(
                            data["TransactionDate"],
                            "%Y-%m-%d %H:%M:%S"
                        )
                        now = datetime.datetime.now()
                        if ((now - date).total_seconds() / 60.0) >= trans_timeout:
                            data["status"] = "Transaction annulée"
                            data["info"] = "Activation annulée"
                    # update Redis
                    record = REDIS_DB.hmset(transId, data)
                    while not record:
                        record = REDIS_DB.hmset(transId, data)
                elif data["operator"] == "airtel-izytv":
                    self.airtel_izytv(transId, data)
                else:
                    LOGS.logger.warning("unknow operator")

    def airtel_izytv(self, transId, data):
        """
        Checks the status of an airtelmoney transaction for izytv bouquet activation.
        If the status returned is success (4) the corresponding izytv bouquet will
            be activated.
        If the status returned is pending (1) we check if the transaction date is over 6min
            in which case it will be declared as failed.
        If the status returned is fail (3) nothing special is done and activation is aborted.
        Redis database is updated in each scenario.
        """
        LOGS.logger.info("[AirtelMoney]{}\n\n".format(data))
        response = AirtelMoney(data).checkTransactionStatus(data['order_id'])
        data['status'] = response.get('message')
        if response['status'] == 4:  # Succeeded
            params = {
                'session': '',
                "operator": data["operator"],
                "caller_num": data["caller_num"],
                "service_type": data["service_type"],
                "client_refnum": data["client_refnum"],
                "device_id": data["device_id"],
                "solde": data["amount"],
                "offre_refnum": data["offre_refnum"],
                "partner_ref": response['response']['TXNID'],
            }
            result = izytv_buy_recharge(params)
            LOGS.logger.info(
                "[AirtelMoney][{}] Activation result: {}\n\n".format(
                    data['order_id'], result,
                )
            )
            if result["status"] == 200:
                LOGS.logger.info(result)
                data["info"] = "Activation reussie"
        elif response['status'] == 1:
            date = datetime.datetime.strptime(
                data["TransactionDate"],
                "%Y-%m-%d %H:%M:%S"
            )
            now = datetime.datetime.now()
            if ((now - date).total_seconds() / 60.0) >= trans_timeout:
                data["status"] = "Transaction annulée"
                data["info"] = "Activation annulée"
        elif response['status'] == 3:
            data["status"] = "Transaction annulée"
            data["info"] = "Activation annulée"
        # update Redis
        record = REDIS_DB.hmset(transId, data)
        while not record:
            record = REDIS_DB.hmset(transId, data)

    def sort_data(self):
        data = []
        for i in self.all_transaction:
            val = REDIS_DB.hgetall(i)
            data.append(decode(val))
        sorted_data = sorted(data, key=lambda i: i['TransactionDate'])
        return sorted_data

    def writeToDB(self):
        hier = (datetime.date.today() - datetime.timedelta(1)).strftime("%Y-%m-%d")
        for data in self.sort_data():
            date = data['TransactionDate']
            day, hour = date.split(' ')
            if (day in hier) and (data["status"] == "Transaction validée") and (data["info"] == "Activation reussie"):
                try:
                    write_transaction_to_db(**data)
                except Exception as e:
                    error = e
                else:
                    error = "Successful"
                LOGS.logger.info("Ecriture transaction N° {}: {}".format(data["partner_ref"], error))

# EOF
