#!/usr/bin/env python
# encoding: utf-8

from to_log import Logger
from datetime import datetime, timedelta

import configparser
import socket
import redis

__all__ = [
    'ADDRESS',
    'APIGW',
    'CONFIG',
    'LOGS',
    'HOSTNAME',
    'SERVICE_CODE',
    'MVOLA'
]

# Server configuration path
CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/payment-services/payment-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
if HOSTNAME.startswith('bldv'):
    APIGW = 'bldv040v.blueline.mg'
elif HOSTNAME.startswith('blst'):
    APIGW = 'blst040v.blueline.mg'
else:
    APIGW = 'api.blueline.mg'

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('payment-services')
LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('payment-services-api')
API_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

# Operators configurations
IzyTV = CONFIG["IzyTV"]
MVOLA = CONFIG["mvola"]
ORANGE_MONEY = CONFIG["orangemoney"]
AIRTEL_MONEY = CONFIG["airtelmoney"]

WSDL_4D = CONFIG['4D']['wsdl']
PAYLOAD = {
    'root': {
        'header': {
            'version': '1',
            'param1': None,
            'ident': CONFIG['4D']['ident'],
            'psw': CONFIG['4D']['pwd'],
        },
        'data': None
    }
}

# Databases
DB_CREDENTIALS = CONFIG["DB"]
REDIS_DB = redis.Redis(db=6)
# EOF
