#!/usr/local/bin python
# encoding: utf-8

from blueflask.lib.errors import bad_request
from blueflask.lib.infos import success
from flask import jsonify, request
from ...mvola import Mvola
from ...consts import LOGS
from . import api
import requests
import json


@api.route("/mvola/paymentRequest", methods=["POST"])
def paymentRequest():
    """
    Faire une demande de paiement
    """
    data = request.get_json()
    LOGS.logger.info(data)
    mvola = Mvola()
    response = mvola.paymentRequest(data)
    return jsonify(response)


@api.route("/mvola/checkTransactionStatus", methods=["GET"])
def checkTransactionStatus():
    """
    Pour Checker le status de la transaction
    """
    LOGS.logger.info("Check transaction status, let's go")
    data = request.get_json()
    LOGS.logger.info(data)
    mvola = Mvola()
    response = mvola.checkTransactionStatus(data["MPGw_TokenID"])
    return jsonify(response)


@api.route("/mvola/checkRedis", methods=["GET"])
def checkRedis():
    """
    Pour Checker le status de la transaction
    """
    data = request.get_json()
    LOGS.logger.info("Check transaction status, let's go")
    mvola = Mvola()
    response = mvola.checkRedis(data["operation_id"])
    return jsonify(response)

# EOF
