#!/usr/bin/env python
# encoding: utf-8


from setuptools import setup, find_packages

setup(
    name="payment-services",
    version="1.7.3",
    packages=find_packages(),
    author="Blueline Madagascar",
    author_email="dev@si.blueline.mg",
    license="MIT",
    install_requires=[
        "flask",
        "click==6.7",
        "pika==0.11.2",
        "blueflask==1.1",
        "rest-client==0.2",
        "records==0.5.2",
        "psycopg2==2.7.3.2",
        "zeep==3.0.0",
        "redis==2.10.6",
        "xmltodict==0.11.0",
        # "apscheduler==3.6.3",
        "APScheduler==3.5.3",
        "python-tds==1.9.1"
    ],
    include_package_data=True,
    entry_points={"console_scripts": ["payment-services=payment_services.api.cli:cmd"]},
)
