#!/usr/local/bin python
# encoding: utf-8

import requests
import xmltodict
from zeep import Client
from .consts import LOGS, PAYLOAD, WSDL_4D


def izytv_buy_recharge(data):
    LOGS.logger.info("Izytv buy offer")
    payload = PAYLOAD
    payload['root']['header']['version'] = '2'
    payload['root']['header']['param1'] = 'ussd_buy_recharge'
    payload['root']['data'] = data
    LOGS.logger.info(payload)
    try:
        LOGS.logger.info("Let's go")
        bluebase_client = Client(WSDL_4D)
        response = bluebase_client.service.S4D(xmltodict.unparse(payload))
        LOGS.logger.info(response)
    except Exception:
        response = {
            "code": "040-06-404",
            "message": "Serveur 4D introuvable",
            "status": 404,
        }
        LOGS.logger.info("Faild :( !!!")
        LOGS.logger.info(response)
    else:
        response = xmltodict.parse(response)
        if response['root']['header'].get("errorNum") == '0':
            if response['root']['data'].get('error'):
                response = {
                    "code": "040-06-{}".format(
                        response['root']['data']['error_num']
                    ),
                    "message": response['root']['data'],
                    "status": int(response['root']['data']['error_num']),
                }
                LOGS.logger.info(response)
            elif response['root']['data'].get('errorNum'):
                response = {
                    "code": "040-06-{}".format(
                        response['root']['data']['error_num']
                    ),
                    "message": "Recharge faild :( ",
                    "status": int(response['root']['data']['error_num']),
                }
                LOGS.logger.info(response)
            elif (response['root']['data']).get("unikid_trans"):
                response = {
                    "code": "040-06-200",
                    "message": "Recharge successfully :) ",
                    "status": 200,
                    "unikid_trans": response['root']['data']['unikid_trans']
                }
                LOGS.logger.info(response)
            else:
                response = {
                    "code": "040-06-200",
                    "message": "Recharge successfully :) ",
                    "status": 200,
                    "unikid_trans": response['root']['data']['unikid_trans']
                }
                LOGS.logger.info(response)
        elif response['root']['header'].get("errorNum") != '0':
            response = {
                "code": "040-06-{}".format(
                    response['root']['header']["errorNum"]
                ),
                "message": response['root']['header']['errorTx'],
                "status": int(response['root']['header']["errorNum"]),
            }
            LOGS.logger.info(response)

    return response


def izytv_check_trans(partner_ref):
    LOGS.logger.info("Izytv check activation")
    data = {'partner_ref': partner_ref}
    response = requests.post(
        "https://blpr042v.blueline.mg:4201/api/v1/ussd/ussd_check_trans",
        json=data
    )
    if response.status_code == 200:
        response = response.json()["root"]
        code = response["header"]["errorNum"]
        message = response["data"]["status"]
        status = response["data"]["trans"]
    else:
        code = response.status_code
        message = "Check failed"
        status = None

    response = {
        "code": code,
        "message": message,
        "status": status,
    }
    LOGS.logger.info(response)
    return response

# EOF
