#!/usr/bin/env python
# encoding: utf-8


from flask import jsonify

from blueflask.lib.decorators import auth as ldap
from blueflask.lib.errors import not_found
from blueflask.lib.infos import no_content

from . import api

import redis

REDIS_SERVER = redis.Redis()


@api.route('/requests', methods=['GET'])
@ldap.login_required
def get_all_existing_requests():
    keys = REDIS_SERVER.keys('simbank:*')
    if not keys:
        return no_content()
    else:
        request_ids = set([i.decode('utf-8').split(':')[1] for i in keys])
        result = {
            'requests': list(request_ids),
            'length': len(request_ids)
            }
        return jsonify(result)


@api.route('/requests/<string:request_id>', methods=['GET'])
@ldap.login_required
def get_request_response(request_id):
    keys = REDIS_SERVER.keys('simbank:{}*'.format(request_id))
    if not keys:
        return not_found()
    else:
        result = {'status': []}
        for key in keys:
            response = REDIS_SERVER.hgetall(key)
            REDIS_SERVER.delete(key)
            content = eval(response[b'content'])
            result['status'].append(content)
        return jsonify(result)

# EOF
