#!/usr/bin/env python
# encoding: utf-8

from .consts import *  # NOQA
from .core import *  # NOQA


import pika

connection = pika.BlockingConnection(
    pika.ConnectionParameters(
        host='localhost',
        virtual_host='/simbank'
        )
    )

channel = connection.channel()

channel.exchange_declare(exchange='async_requests', exchange_type='topic')

channel.queue_declare(queue='GET.simbank', durable=True)
channel.queue_bind(exchange='async_requests', queue='GET.simbank')

channel.queue_declare(queue='POST.simbank', durable=True)
channel.queue_bind(exchange='async_requests', queue='POST.simbank')

channel.queue_declare(queue='PUT.simbank', durable=True)
channel.queue_bind(exchange='async_requests', queue='PUT.simbank')

channel.queue_declare(queue='DELETE.simbank', durable=True)
channel.queue_bind(exchange='async_requests', queue='DELETE.simbank')

connection.close()

# EOF
