# -*- coding: utf-8 -*-

from flask import jsonify, request

from blueflask.lib.errors import not_found
from blueflask.lib.infos import success

from ....consts import API_REGISTRY
from . import api


@api.route('/registry/<string:service>', methods=['GET'])
def get_service_infos_in_registry(service):
    """
    Informations sur un service dans le registre.
    ---
    tags:
      - Registry
    """
    infos = API_REGISTRY.hgetall('service:{}-services'.format(service))
    if not infos:
        return not_found()
    result = {
        key.decode('utf-8'): value.decode('utf-8')
        for key, value in infos.items()
        }
    return jsonify(result)


@api.route('/registry', methods=['POST', 'DELETE'])
def set_info_in_registry():
    """
    Inscription d'un service au registre.
    ---
    tags:
      - Registry
    """
    data = request.get_json()
    service = data['service']
    key = 'service:{}'.format(service)
    if request.method == 'DELETE':
        if key not in [i.decode('utf-8') for i in API_REGISTRY.keys()]:
            return not_found("Ce service n'existe pas")
        API_REGISTRY.delete(key)
    else:
        del data['service']
        API_REGISTRY.hmset(key, data)
    return success()

# EOF
