# -*- coding: utf-8 -*-

"""
Ce module est un API Gateway permettant
d'accéder à tout un ensemble d'APIs chez Blueline.
"""


from to_log import Logger

import configparser
import socket

import redis


__all__ = [
    'API_LOGS',
    'API_REGISTRY',
    'BLUEFLASK_LOGS',
    'CONFIG',
    'HOSTNAME',
    'HTTP_VERBS',
    'LOGS',
    'LDAP_API',
    'REST_CLIENT_LOGS',
    'SERVICE_CODE',
    'SPYNE_LOGS'
    ]


CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/sponge/sponge.conf')

SERVICE_CODE = CONFIG['APP']['service_code']

API_REGISTRY = redis.Redis(db=15)
# le registre est TOUJOURS installé sur le même hôte que sponge
HOSTNAME = socket.gethostname().split('.')[0]
LDAP_API = 'https://{host}.blueline.mg:{port}/api/v2'.format(
    host=API_REGISTRY.hget('service:ldap-services', 'host').decode('utf-8'),
    port=API_REGISTRY.hget('service:ldap-services', 'port').decode('utf-8')
    )
LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('sponge')
LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('sponge-api')
API_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

SPYNE_LOGS = Logger('spyne.protocol.xml')
SPYNE_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(LOG_FILE, level=LOG_LEVEL)

HTTP_VERBS = (
    'GET', 'get',
    'POST', 'post',
    'PUT', 'put',
    'DELETE', 'delete'
    )

# EOF
