#!/usr/bin/env python
# encoding: utf-8


from .soap import app as soap_app
from .rest import app as rest_app
from ..consts import API_REGISTRY
from ..gateway import Api

import click
import requests


@click.group()
def cmd():
    pass


@cmd.command()
@click.option('--service', default=None)
def check_service_status(service):
    """Sonde de vérification d'état des services déclarés"""
    if not service:
        services = [
            i.decode('utf-8').split(':', 1)[1].split('-')[0]
            for i in API_REGISTRY.keys('service:*-services')
            ]
    else:
        services = [service]
    for service in services:
        result = requests.head(Api(service).location+'/apidoc/', timeout=10)
        if result.status_code != 200:
            # on change le status du service dans API_REGISTRY
            API_REGISTRY.hset(
                'service:{}-services'.format(service),
                'status',
                'down'
                )
            click.echo('{}-services est down'.format(service))
        else:
            API_REGISTRY.hset(
                'service:{}-services'.format(service),
                'status',
                'up'
                )
            click.echo('{}-services est up'.format(service))


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
@click.option('--soap', is_flag=True, default=False)
@click.option('--rest', is_flag=True, default=False)
def runserver(host, port, soap, rest):
    """Serveur WSGI simple, inutilisable en production"""

    import logging
    logging.basicConfig(level=logging.DEBUG)
    if rest and soap:
        message = (
            "Vous ne vous sentez pas bien. "
            "Prenez un cachet et allez vous reposer"
            )
        click.echo(message)
    elif rest:
        rest_app.run(debug=True, host=host, port=port)
    elif soap:
        from wsgiref.simple_server import make_server
        server = make_server(host, port, soap_app)
        server.serve_forever()

# EOF
