# -*- coding: utf-8 -*-

from flask import redirect, request
from flask_httpauth import HTTPBasicAuth

from blueflask.lib.errors import not_found

from ....gateway import Api
from ....consts import SERVICE_CODE
from . import api

auth = HTTPBasicAuth()


@auth.verify_password
def verify_password(username, password):
    ldap_api = Api('ldap')
    response = ldap_api.call(
        'POST',
        '/auth',
        auth=(username, password),
        headers=request.headers
        )
    if response['status'] != 204:
        return False
    else:
        return True


@api.route('/<string:service>', methods=['GET'])
@auth.login_required
def api_docs(service):
    try:
        api_service = Api(service)
    except (KeyError, ValueError):
        return not_found(service_code=SERVICE_CODE)
    else:
        return redirect(api_service.location+'/apidoc/')
