#!/usr/bin/env python
# encoding: utf-8
import json

import rest_client
import datetime
import pika


from . import CONFIG
from . import LOGS
from .core import check_parameters
from .core import transaction_date, format_phonenumber
from . import URL_STATUS, URL_STATUS_AIRTEL, REDIS_CHECK


class Bluebase:
    """
    api pour 4D
    """

    def __init__(self):
        self.url = CONFIG["SERVICES"]["bluebase"]
        self.client = rest_client.RestClient(self.url)

    # Le type du bouquet depend de
    # la localisation de la carte
    def user_bouquet(self, area):
        if area == "Tana":
            bouquet_type = CONFIG["MISC"]["blntv_tana_type"]
        if area == "Province":
            bouquet_type = CONFIG["MISC"]["blntv_province_type"]
        return bouquet_type

    # rendre dynamique l'option jour pour internet
    def days_number(self, pcode):
        if pcode in CONFIG["MISC"]:
            jour = CONFIG["MISC"][pcode]
        else:
            jour = CONFIG["MISC"]["pcode_other"]
        return jour

    @check_parameters("caller_num", "login_type", "login")
    # besoin d'un refactoring
    def authentication(self, token, **data):
        """
        Cette méthode permet de vérifier l'existence d'un client
        et de récupérer ses abonnements suivant le type de service
        passé en paramètre.
        """
        request = data["request"]
        data["type_auth"] = data["login_type"]
        data["login_auth"] = data["login"]
        # the_device = data['login_auth']
        del data["login"]
        del data["login_type"]
        del data["request"]
        numero = data["caller_num"]
        if data["type_auth"] in ["internet_num", "bip_num"]:
            if len(data["login_auth"]) != 12:
                data["login_auth"] = data["login_auth"][-9:]
            elif data["login_auth"].startswith("261"):
                data["login_auth"] = data["login_auth"][-9:]
        response = self.client.post(
            "/auth_ussd", auth=(token, ""), headers=request.headers, json=data
        )
        LOGS.logger.info("affichage temps de reponse: {}".format(response))
        if response["status"] == 200:
            monbouquet = {}
            days = {}
            product_code = {}
            blue_data = response["content"]["root"]["data"]
            LOGS.logger.info(blue_data)
            if numero.startswith("03900") or numero.startswith("3900"):
                blue_data["num_is_name"] = "Vrai"
            result = {
                "status": response["status"],
                "data": {
                    "customer_id": blue_data["client_refnum"],
                    "caller_num": numero,
                    "operator": data["operator"],
                    "name": blue_data["client_nom"],
                    "last_name": blue_data["client_prenom"],
                    "num_is_mine": blue_data["num_is_mine"],
                    "device_name": blue_data["device_id"],
                },
            }
            if result["data"]["name"] is None:
                result["data"]["name"] = "-"
            if result["data"]["last_name"] is None:
                result["data"]["last_name"] = "-"
            if data["service_type"] in ["tv"]:
                result["data"]["jour"] = CONFIG["MISC"][
                    "validity_option_{}".format(data["service_type"])
                ]
            if "device_id" in blue_data:
                if isinstance(blue_data["device_id"], str):
                    device = blue_data["device_id"]
                    # si la carte tv ou l'adresse mac est choisi
                    # comme methode d'authentification
                    # le device_name retourné devra être la même
                    # que celui qui est passe en parametre
                    # via [login_auth]
                    if data["login_auth"] in ["internet_num", "tv_card_num"]:
                        result["data"]["device_name"] = [data["login_auth"]]
                    else:
                        result["data"]["device_name"] = [blue_data["device_id"]]
                    if data["service_type"] == "tv":
                        area = blue_data["device_ville"]
                        bouquet = self.user_bouquet(area)
                        monbouquet[device] = bouquet
                        result["data"]["bouquet"] = monbouquet
                    elif data["service_type"] == "internet":
                        result["data"]["product_code"] = blue_data["device_pcode"]
                        pcode = "pcode_{}".format(result["data"]["product_code"])
                        result["data"]["jour"] = self.days_number(pcode)
                else:
                    result["data"]["device_name"] = []
                    if data["login_auth"] in blue_data["device_id"]:
                        device = data["login_auth"]
                        myindex = blue_data["device_id"].index(device)
                        result["data"]["device_name"] = [device]
                        if data["service_type"] == "tv":
                            area = blue_data["device_ville"][myindex]
                            bouquet = self.user_bouquet(area)
                            monbouquet[device] = bouquet
                            result["data"]["bouquet"] = monbouquet
                        elif data["service_type"] == "internet":
                            product_code[device] = blue_data["device_pcode"][myindex]
                            result["data"]["product_code"] = product_code[device]
                            pcode = "pcode_{}".format(result["data"]["product_code"])
                            result["data"]["jour"] = self.days_number(pcode)

                    else:
                        if data["operator"] == "airtel":
                            devices = blue_data["device_id"][:3]
                        else:
                            devices = blue_data["device_id"]
                        for device in devices:
                            myindex = blue_data["device_id"].index(device)
                            LOGS.logger.info(device)
                            result["data"]["device_name"].append(device)
                            if data["service_type"] == "tv":
                                area = blue_data["device_ville"][myindex]
                                bouquet = self.user_bouquet(area)
                                monbouquet[device] = bouquet
                                result["data"]["bouquet"] = monbouquet
                            elif data["service_type"] == "internet":
                                device_pcode = blue_data["device_pcode"][myindex]
                                product_code[device] = device_pcode
                                pcode = "pcode_{}".format(device_pcode)
                                days[device] = self.days_number(pcode)
                                result["data"]["jour"] = days
                            result["data"]["product_code"] = product_code
            return result
        else:
            result = {"status": response["status"], "data": response["content"]}
            LOGS.logger.info("ca se passe par ici")
            LOGS.logger.info(result["data"])
            return result

    @check_parameters("caller_num", "customer_id")
    def subscriptions(self, token, **data):
        """
        Cette méthode permet de récupérer les informations relatives à
        un abonnement donné.
        """
        request = data["request"]
        data["client_refnum"] = data["customer_id"]
        data["device_id"] = data["device_name"]
        del data["customer_id"]
        del data["request"]
        del data["device_name"]
        if data["service_type"] == "internet":
            if len(data["device_id"]) != 12:
                data["device_id"] = data["device_id"][-9:]
            elif data["device_id"].startswith("261"):
                data["device_id"] = data["device_id"][-9:]
        response = self.client.post(
            "/ussd_get_infos", auth=(token, ""), headers=request.headers, json=data
        )
        if response["status"] == 200:
            response_data = response["content"]["root"]["data"]
            subscriptions = response_data["bouquet"]
            if not isinstance(subscriptions, list):
                subscriptions = [subscriptions]
            subscriptions = [
                {"name": subscription["intitule"], "value": subscription["date_fin"]}
                for subscription in subscriptions
            ]
            # n'afficher que les 3 dernieres offres pour l'ussd d'airtel
            # il faudra trouver un autre moyen plus intelligent de gerer
            # cela
            if len(subscriptions) > 3 and data["operator"] == "airtel":
                subscriptions = subscriptions[:3]
            result = {
                "status": response["status"],
                "data": subscriptions,
                "num_is_mine": response_data["num_is_mine"],
                "caller_num": data["caller_num"],
            }
            return result
        else:
            return {"status": response["status"], "data": response["content"]}

    @check_parameters("caller_num", "customer_id")
    def last_offer(self, token, **data):
        """
        Une méthode qui permettra de récupérer les details du dernier achat effetuee par
        le client. Ceci permettra de renouveller facilement l'abonnement  du client avec
        le meme offre
        """
        request = data["request"]
        data["client_refnum"] = data["customer_id"]
        data["solde"] = 1000000
        data["device_id"] = format_phonenumber(data["service_type"], data["device_id"])
        response = self.client.post(
            "/ussd_get_last_achat", auth=(token, ""), headers=request.headers, json=data
        )
        return response

    # Peut etre rajouter un autre tag pour marquer
    # si on veut avoir tous les offres dispo ou
    # juste la derniere offre acheter
    @check_parameters("caller_num", "customer_id")
    def offers(self, token, **data):
        """
        Cette méthode permet de récupérer les recharges disponibles
        sur le crm selon le nb de jour et/ou le type de l'offre.
        """
        request = data["request"]
        data["client_refnum"] = data["customer_id"]
        # On doit quand meme passer au CRM
        # Une certaine montant de solde
        # On mettra par defaut solde_default
        # Quelque soit l'operateur
        data["solde"] = CONFIG["MISC"]["default_balance"]
        data["device_id"] = data["device_name"]
        del data["request"]
        del data["customer_id"]
        del data["device_name"]
        data["device_id"] = format_phonenumber(data["service_type"], data["device_id"])
        if "last" in data:
            if data["last"] == "True" or data["last"] == "true":
                response = self.client.post(
                    "/ussd_get_last_achat",
                    auth=(token, ""),
                    headers=request.headers,
                    json=data,
                )
                if response["status"] == 200:
                    data = response["content"]["root"]["data"]
                    offers = data["last_offre"]
                    if not isinstance(offers, list):
                        offers = [offers]
                    offers = [
                        {
                            "name": offer["intitule"],
                            "price": offer["price"],
                            "offer_id": offer["refnum"],
                        }
                        for offer in offers
                    ]
                    result = {"status": response["status"], "data": offers}
                    return result
                else:
                    return {"status": response["status"], "data": response["content"]}
            else:
                response = {
                    "code": "040-05-500",
                    "info": "option non encore definie",
                    "status": "500",
                    "message": "à définir dans le v2",
                }
                return response
        else:
            response = self.client.post(
                "/ussd_get_recharge",
                auth=(token, ""),
                headers=request.headers,
                json=data,
            )
            if response["status"] == 200:
                data = response["content"]["root"]["data"]
                offers = data["offre"]
                if not isinstance(offers, list):
                    offers = [offers]
                offers = [
                    {
                        "name": offer["intitule"],
                        "price": offer["price"],
                        "offer_id": offer["refnum"],
                    }
                    for offer in offers
                ]
                result = {"status": response["status"], "data": offers}
                return result
            else:
                return {"status": response["status"], "data": response["content"]}

    # traitement asynchrone des activations de l'offre
    # producer definition
    # à implementer plus proprement aprés
    def process(self, message):
        connection = pika.BlockingConnection(
            pika.ConnectionParameters(host="localhost", virtual_host="/ussd")
        )
        channel = connection.channel()
        channel.exchange_declare(exchange="ussd_offer", exchange_type="topic")
        channel.basic_publish(
            routing_key="ussd_msg",
            exchange="ussd_offer",
            properties=pika.BasicProperties(
                app_id="ussd-services", delivery_mode=2  # rendre le message persistant
            ),
            body=message,
        )
        connection.close()

    @check_parameters(
        "caller_num", "customer_id", "offer_id", "device_name", "offer_ref"
    )
    def buy_recharge(self, token, **data):
        """
        Cette méthode permet de placer un ordre d'achat de recharge.
        l'activation sera effectuée en mode asyncrhone
        """
        data["device_id"] = data["device_name"]
        request = data["request"]
        headers = request.headers
        request_id = headers["X-Request-Id"]
        balance = data["balance"]
        LOGS.logger.info(data)
        del data["request"]
        del data["device_name"]
        if data["service_type"] == "internet":
            if len(data["device_id"]) != 12:
                data["device_id"] = data["device_id"][-9:]
            elif data["device_id"].startswith("261"):
                data["device_id"] = data["device_id"][-9:]
        activation_data = {
            "client_refnum": data["customer_id"],
            "customer_id": data["customer_id"],
            "offre_refnum": data["offer_id"],
            "amount": data["amount"],
            "balance": balance,
            "device_id": data["device_id"],
            "caller_num": data["caller_num"],
            "operator": data["operator"],
            "offer_ref": data["offer_id"],
            "bundle_name": data["bundle_name"],
            "service_type": data["service_type"],
            "headers": request.headers,
            "token": token,
            "transaction_date": transaction_date(),
            "request_id": request_id,
        }
        if "partner_ref" in data and data["operator"] != "bip":
            activation_data["partner_ref"] = data["partner_ref"]
        else:
            activation_data["partner_ref"] = request_id
        # Redis pour check activation
        REDIS_CHECK.hmset(activation_data["partner_ref"], activation_data)
        result = {
            "data": activation_data,
            "status": 200,
            "info": "ack",
            "message": "traitement en cours",
        }
        LOGS.logger.info(result)
        message = json.dumps(result)
        self.process(message)
        if data["operator"] == "airtel":
            url_status = URL_STATUS_AIRTEL
        else:
            url_status = URL_STATUS
        if result["data"]["operator"] != "bip":
            details = "{}/ussd/v1/clients/{}/{}".format(
                url_status, data["operator"], request_id
            )
        else:
            details = "resultat envoyé via sms"
        response = {
            "status": result["status"],
            "info": "traitement en cours",
            "message": details,
            "code": "040-05-200",
        }
        return response
