#!/usr/bin/env python
# encoding: utf-8
import functools
import datetime
import records

from . import BIP_DB_CREDENTIALS
from . import LOGS

SERVICE_CODE = "040-05"


def check_parameters(arg1=None, arg2=None, arg3=None, arg4=None, arg5=None):
    """
    Décorateur prenant des arguments qui représentent
    les paramètres nommés attendus dans la signature
    de la fonction
    """

    def decorated(func):
        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            mandatory_keys = [
                "operator",
                "service_type",
                "request",
                arg1,
                arg2,
                arg3,
                arg4,
            ]
            mandatory_keys = [i for i in mandatory_keys if i]
            for item in mandatory_keys:
                if item not in kwargs:
                    raise SyntaxError(
                        "L'argument '{arg}' est introuvable".format(arg=item)
                    )
            return func(*args, **kwargs)

        return wrapper

    return decorated


# je devrai renommer ce methode
# le but c'est juste d'avoir la date
# et l'heure ou on effectue une transaction
def transaction_date():
    mydate = datetime.datetime.today()
    transaction_date = mydate.strftime("%Y-%m-%d %H:%M:%S")
    return transaction_date


def format_phonenumber(service_type, device_id):
    if service_type == "internet":
        if device_id.startswith("261") or len(device_id) != 12:
            device_id = device_id[-9:]
    return device_id


def database_url(**kwargs):
    """
    On aura besoin d'un database relationel
    pour enregistrer les activations d'offres
    bip via un partenaire. utile pour la compta
    odoo
    """
    url = "{eng}://{user}:{password}@{host}:{port}/{name}".format(
        eng=BIP_DB_CREDENTIALS["engine"],
        user=BIP_DB_CREDENTIALS["user"],
        password=BIP_DB_CREDENTIALS["password"],
        host=BIP_DB_CREDENTIALS["host"],
        port=BIP_DB_CREDENTIALS["port"],
        name=BIP_DB_CREDENTIALS["name"],
    )
    return url


def write_bip_transaction_to_db(**kwargs):
    """
    Ecrire les transactions des offres bip
    via partenaire dans une bdd pgsql
    en utilisant records
    """
    url = database_url(**BIP_DB_CREDENTIALS)
    partner_ref = kwargs.get("partner_ref")
    request_id = kwargs.get("request_id")
    source_num = kwargs.get("caller_num")
    destination_num = kwargs.get("device_name")
    montant = kwargs.get("amount")
    bundle_name = kwargs.get("bundle_name")
    datetime_req = kwargs.get("transaction_date")
    partner_id = kwargs.get("operator")
    sql = (
        "INSERT INTO bip_transaction ("
        "partner_ref, "
        "request_id, "
        "source_num, "
        "destination_num, "
        "datetime_req, "
        "montant, "
        "bundle_name, "
        "partner_id) "
        "VALUES ("
        ":partner_ref, "
        ":request_id, "
        ":source_num, "
        ":destination_num, "
        ":datetime_req, "
        ":montant, "
        ":bundle_name,"
        ":partner_id )"
    )
    with records.Database(url) as db:
        db.query(
            sql,
            partner_ref=partner_ref,
            request_id=request_id,
            source_num=source_num,
            destination_num=destination_num,
            montant=montant,
            bundle_name=bundle_name,
            datetime_req=datetime_req,
            partner_id=partner_id,
        )
