#!/usr/bin/env python
# encoding: utf-8


"""
Command Line Interface
"""

from ..amqp_worker import process, Worker
from ..bluebase_check import check_trans

from . import app

import click


@click.group()
def cmd():
    pass


@cmd.command()
@click.argument('queue')
@click.option('--workers', type=int, default=1)
def async_daemon(queue, workers):
    """Lance un ou plusieurs workers pour une file d'attente"""

    if not workers:
        click.echo("il me faut au moins un worker")
    elif workers == 1:
        process(queue)
    else:
        threads = [
            Worker('worker-{}'.format(i), queue)
            for i in range(workers)
        ]
        for thread in threads:
            thread.start()


@cmd.command()
def check_activation():
    check_trans()


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(host=host, port=port, debug=True)

# EOF
