# -*- encode: utf- -*-

import requests
import smtplib
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

from . import REDIS_CHECK


def check_trans():
    for key in REDIS_CHECK.keys():
        active = False
        val = REDIS_CHECK.hgetall(key)
        params = {
            key.decode('utf-8'): value.decode('utf-8')
            for (key, value) in val.items()
        }
        data = {'partner_ref': params['partner_ref']}
        response = requests.post(
            "https://blpr042v.blueline.mg:4201/api/v1/ussd/ussd_check_trans",
            json=data
        )
        if response.status_code == 200:
            response = response.json()["root"]
            if response["data"]["trans"] == "done":
                REDIS_CHECK.delete(params["partner_ref"])
                active = True

        if not active:
            if params.get("tentative"):
                if int(params["tentative"]) == 10:
                    notify(params["partner_ref"])
                else:
                    params["tentative"] = int(params["tentative"]) + 1
                    REDIS_CHECK.hmset(params["partner_ref"], params)
            else:
                params["tentative"] = 1
                REDIS_CHECK.hmset(params["partner_ref"], params)


def notify(partner_ref):
    message = (
        """La transaction {} a atteint le maximum pour"""
        """ le check activation sur bluebase""".format(partner_ref)
    )
    fromaddr = "ussd@si.blueline.mg"
    toaddr = ["moria.miraifahasoavana@staff.blueline.mg", "dev@si.blueline.mg"]
    msg = MIMEMultipart()
    msg['From'] = fromaddr
    msg['Subject'] = "Check activation bluebase"
    body = message
    msg.attach(MIMEText(body, 'plain'))
    smtp = smtplib.SMTP()
    smtp.connect("smtp.blueline.mg", port=10026)
    text = msg.as_string()
    for addr in toaddr:
        msg['To'] = addr
        smtp.sendmail(fromaddr, toaddr, text)
    smtp.quit()

# EOF
